<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Common;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class Id implements ResultInterface, \JsonSerializable
{
    private $id;

    private function __construct(int $id)
    {
        $this->id = $id;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
        ];
    }
}
