<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

final class ConsignmentIdsCollection implements \IteratorAggregate, \JsonSerializable
{
    /**
     * @var int[]
     */
    private $items;

    public function __construct(int ...$items)
    {
        $this->items = $items;
    }

    public function getItems(): array
    {
        return $this->items;
    }

    public function withItems(int ...$items): self
    {
        $new = clone $this;
        $new->items = $items;

        return $new;
    }

    /**
     * @return \Iterator<int, int>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->items);
    }

    public function jsonSerialize(): array
    {
        return $this->items;
    }
}
