<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

final class DAWOptions
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $building;

    /**
     * @var string
     */
    private $floor;

    /**
     * @var string
     */
    private $room;

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $altrec;

    public function getName(): string
    {
        return $this->name;
    }

    public function withName(string $name): DAWOptions
    {
        $new = clone $this;
        $new->name = $name;

        return $new;
    }

    public function getBuilding(): string
    {
        return $this->building;
    }

    public function withBuilding(string $building): DAWOptions
    {
        $new = clone $this;
        $new->building = $building;

        return $new;
    }

    public function getFloor(): string
    {
        return $this->floor;
    }

    public function withFloor(string $floor): DAWOptions
    {
        $new = clone $this;
        $new->floor = $floor;

        return $new;
    }

    public function getRoom(): string
    {
        return $this->room;
    }

    public function withRoom(string $room): DAWOptions
    {
        $new = clone $this;
        $new->room = $room;

        return $new;
    }

    public function getPhone(): string
    {
        return $this->phone;
    }

    public function withPhone(string $phone): DAWOptions
    {
        $new = clone $this;
        $new->phone = $phone;

        return $new;
    }

    public function getAltrec(): string
    {
        return $this->altrec;
    }

    public function withAltrec(string $altrec): DAWOptions
    {
        $new = clone $this;
        $new->altrec = $altrec;

        return $new;
    }
}
