<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

/**
 * @implements \IteratorAggregate<int, Parcel>
 */
final class ParcelsCollection implements \IteratorAggregate, \JsonSerializable
{
    /**
     * @var Parcel[]
     */
    private $items;

    public function __construct(Parcel ...$items)
    {
        $this->items = $items;
    }

    /**
     * @return Parcel[]
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return \Iterator<int, Parcel>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->items);
    }

    public function withItems(Parcel ...$items): ParcelsCollection
    {
        $new = clone $this;
        $new->items = $items;

        return $new;
    }

    public function jsonSerialize()
    {
        return $this->items;
    }
}
