<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Printout;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

/**
 * @implements \IteratorAggregate<int, Label>
 */
final class LabelsCollection implements ResultInterface, \JsonSerializable, \IteratorAggregate, \Countable
{
    /**
     * @var Label[]
     */
    private $items;

    private function __construct(Label ...$items)
    {
        $this->items = $items;
    }

    /**
     * @return Label[]
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return \Iterator<int, Label>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->items);
    }

    public function jsonSerialize(): array
    {
        return $this->items;
    }

    public function count(): int
    {
        return count($this->items);
    }
}
