<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Carrier;

final class CarrierId
{
    private $value;

    private function __construct(int $id)
    {
        $this->value = $id;
    }

    public static function from(int $id): self
    {
        if (0 >= $id) {
            throw new \InvalidArgumentException('Identifier must be greater than 0.');
        }

        return new self($id);
    }

    public function getValue(): int
    {
        return $this->value;
    }
}
