<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

use Gls\GlsPoland\Asset\AssetManagerInterface;
use Symfony\Component\Asset\Packages;

final class AssetPackageInitializer implements ConfigurationInitializerInterface
{
    private $packages;
    private $assetManager;

    public function __construct(Packages $packages, AssetManagerInterface $assetManager)
    {
        $this->packages = $packages;
        $this->assetManager = $assetManager;
    }

    public function init(): void
    {
        $this->packages->addPackage('GlsPoland', $this->assetManager->getPackage());
    }
}
