<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Consignment\DTO;

use Gls\GlsPoland\AdePlus\Consignment\Parcel as AdeParcel;
use Symfony\Component\Validator\Constraints as Assert;

class Parcel
{
    /**
     * @var float|null
     *
     * @Assert\NotNull()
     * @Assert\GreaterThanOrEqual(0.01)
     */
    private $weight;

    /**
     * @var string|null
     *
     * @Assert\Length(max="25")
     */
    private $reference;

    public function getWeightKg(): float
    {
        return (float) $this->weight;
    }

    public function setWeightKg(?float $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function setReference(?string $reference): self
    {
        $this->reference = $reference;

        return $this;
    }

    public function asAdeParcel(): AdeParcel
    {
        return (new AdeParcel($this->getWeightKg()))
            ->withReference($this->getReference());
    }
}
