<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Consignment\Exception;

final class NoPickupForConsignmentException extends \RuntimeException
{
    private $consignmentId;

    public function __construct(int $consignmentId, string $message = '')
    {
        parent::__construct($message);
        $this->consignmentId = $consignmentId;
    }

    public static function create(int $consignmentId): self
    {
        return new self($consignmentId, sprintf('No associated pickup found for consignment ID %d.', $consignmentId));
    }

    public function getConsignmentId(): int
    {
        return $this->consignmentId;
    }
}
