<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Form\ChoiceProvider\ShopDeliveryCountryChoiceProvider;
use Gls\GlsPoland\PrestaShop\Message\CreateShopDeliveryCarrierCommand;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShop\PrestaShop\Core\Form\FormChoiceProviderInterface;
use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\ChoiceList\Loader\CallbackChoiceLoader;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CreateShopDeliveryCarrierType extends AbstractType
{
    use TranslatorAwareTrait;

    private $countryChoiceProvider;

    /**
     * @param ShopDeliveryCountryChoiceProvider $countryChoiceProvider
     */
    public function __construct(FormChoiceProviderInterface $countryChoiceProvider)
    {
        $this->countryChoiceProvider = $countryChoiceProvider;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', TextType::class, [
                'label' => $this->getTranslator()->trans('Name', [], 'Admin.Global'),
            ])
            ->add('countryIsoCodes', MaterialChoiceTableType::class, [
                'choice_loader' => new CallbackChoiceLoader([$this->countryChoiceProvider, 'getChoices']),
                'preferred_choices' => ['PL'],
                'label' => $this->getTranslator()->trans('Countries', [], 'Admin.Global'),
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('data_class', CreateShopDeliveryCarrierCommand::class);
    }
}
