<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Availability;

use Gls\GlsPoland\Configuration\Api;
use Gls\GlsPoland\Entity\Carrier;
use Gls\GlsPoland\Entity\ShopDeliveryCarrier;

final class ApiConfigurationChecker implements CarrierAvailabilityCheckerInterface
{
    private $configuration;

    public function __construct(Api\PersistentConfigurationInterface $configuration)
    {
        $this->configuration = $configuration;
    }

    public function isAvailable(Carrier $carrier, \Cart $cart): bool
    {
        return !$carrier instanceof ShopDeliveryCarrier || null !== $this->configuration->getCredentials();
    }
}
