<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Module\SuperCheckout;

use Gls\GlsPoland\PrestaShop\Checkout\Module\SuperCheckout;
use Gls\GlsPoland\PrestaShop\Event\FrontControllerInitializedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

final class FixRequestParamsListener implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            FrontControllerInitializedEvent::class => 'onFrontControllerInitialized',
        ];
    }

    public function onFrontControllerInitialized(FrontControllerInitializedEvent $event): void
    {
        if (null === $request = $event->getRequest()) {
            return;
        }

        if (!SuperCheckout::supports($event->getController(), null, $request)) {
            return;
        }

        SuperCheckout::fixRequestParameters($request);
    }
}
