<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Common;

use Gls\GlsPoland\Configuration\Initializer\ConfigurationInitializerInterface;
use Gls\GlsPoland\PrestaShop\Hook\HookInterface;

final class ActionDispatcherBefore implements HookInterface
{
    public const HOOK_NAME = 'actionDispatcherBefore';

    /**
     * @var ConfigurationInitializerInterface
     */
    private $initializer;

    /**
     * @var bool
     */
    private $initialized = false;

    public function __construct(ConfigurationInitializerInterface $initializer)
    {
        $this->initializer = $initializer;
    }

    /**
     * @param array{controller_type: int} $parameters
     */
    public function execute(array $parameters): void
    {
        if ($this->initialized) {
            return;
        }

        if (in_array($parameters['controller_type'], [\Dispatcher::FC_FRONT, \Dispatcher::FC_MODULE], true)) {
            return;
        }

        $this->initializer->init();
        $this->initialized = true;
    }
}
