<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook;

class HookNotFoundException extends \RuntimeException
{
    private $hookName;

    public function __construct(string $hookName, string $message = '', int $code = 0, ?\Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->hookName = $hookName;
    }

    public static function notImplemented(string $hookName): self
    {
        return new self($hookName, sprintf('The module does not implement hook "%s".', $hookName));
    }

    public static function notAvailable(string $hookName, \Exception $previous): self
    {
        return new self($hookName, sprintf('Hook "%s" is not available in the current context. Are you trying to execute an admin hook in the Front Office or a front hook in the Back Office?', $hookName), 0, $previous);
    }

    public static function notFound(string $hookName, \Exception $previous): self
    {
        return new self($hookName, sprintf('Hook "%s" was not found.', $hookName), 0, $previous);
    }

    public function getHookName(): string
    {
        return $this->hookName;
    }
}
