<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

use Symfony\Component\Validator\Constraints as Assert;

abstract class AbstractCreateCarrierCommand implements CreateCarrierCommandInterface
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank()
     * @Assert\Length(max="64")
     */
    private $name;

    /**
     * @var string[]
     *
     * @Assert\NotNull()
     * @Assert\Count(min="1")
     * @Assert\All({
     *     @Assert\Type("string")
     * })
     */
    private $countryIsoCodes;

    public function __construct(?string $name = null, string ...$countryIsoCodes)
    {
        $this->name = $name;
        $this->countryIsoCodes = $countryIsoCodes;
    }

    public function getName(): string
    {
        return $this->name ?? '';
    }

    /**
     * @return static
     */
    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getCountryIsoCodes(): array
    {
        return $this->countryIsoCodes ?? [];
    }

    /**
     * @return static
     */
    public function setCountryIsoCodes(?array $isoCodes): self
    {
        $this->countryIsoCodes = $isoCodes;

        return $this;
    }

    public function isDomestic(): bool
    {
        return ['PL'] === $this->countryIsoCodes;
    }
}
