<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\MessageHandler\Carrier\Assembler;

use Gls\GlsPoland\PrestaShop\DTO;
use Gls\GlsPoland\PrestaShop\Message\CreateCarrierCommandInterface;
use Gls\GlsPoland\PrestaShop\ObjectModel\Repository\GroupRepository;

final class GroupsAssembler implements CarrierAssemblerInterface
{
    private $groupRepository;

    private $groups;

    public function __construct(GroupRepository $groupRepository)
    {
        $this->groupRepository = $groupRepository;
    }

    public function assemble(DTO\Carrier $carrier, CreateCarrierCommandInterface $command): void
    {
        foreach ($this->getGroups() as $group) {
            $carrier->addGroup($group);
        }
    }

    /**
     * @return iterable<\Group>
     */
    private function getGroups(): iterable
    {
        return $this->groups = ($this->groups ?? $this->groupRepository->findAll());
    }
}
