<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\ObjectModel\Repository;

use Doctrine\DBAL\Connection;
use Gls\GlsPoland\PrestaShop\ObjectModel\HydratorInterface;
use Gls\GlsPoland\PrestaShop\ObjectModel\Persistence;
use Gls\GlsPoland\PrestaShop\ObjectModel\PersistenceInterface;

/**
 * @extends AbstractObjectModelRepository<\OrderCarrier>
 */
final class OrderCarrierRepository extends AbstractObjectModelRepository
{
    private $persistence;

    public function __construct(Connection $connection, string $dbPrefix, ?HydratorInterface $hydrator = null, ?PersistenceInterface $persistence = null)
    {
        parent::__construct(\OrderCarrier::class, $connection, $dbPrefix, $hydrator);

        $this->persistence = $persistence ?? new Persistence();
    }

    public function update(\OrderCarrier $orderCarrier): void
    {
        if (0 >= (int) $orderCarrier->id) {
            throw new \InvalidArgumentException('Cannot update order carrier: identifier is invalid.');
        }

        $this->persistence->save($orderCarrier);
        $this->objectsById[$orderCarrier->id] = $orderCarrier;
    }
}
